/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.config;

import meldexun.renderlib.util.ResourceLocationMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.common.config.Config;

@Config(modid="renderlib")
public class RenderLibConfig {
    public static OpenGLDebugOutput openGLDebugOutput = new OpenGLDebugOutput();
    public static int mainMenuFPS = 60;
    @Config.Comment(value={"If set to true the main menu FPS is synced to the in game FPS (but clamped between 30 and 240)."})
    public static boolean mainMenuFPSSynced = false;
    public static boolean showFrameTimes = false;
    @Config.Comment(value={"Most tile entities have static bounding boxes and thus they can be cached. Tile entities whose bounding boxes are likely to change every frame or so should be added to the blacklist. Tile entities whose bounding only change every once in a while should be covered by cache updates (update speed adjustable through tileEntityCachedBoundingBoxUpdateInterval)"})
    public static boolean tileEntityCachedBoundingBoxEnabled = true;
    @Config.Comment(value={"Every frame there is a 1 in x chance to update the cached bounding box. Higher = better performance, Lower = tile entities with dynamic bounding boxes get updated faster."})
    @Config.RangeInt(min=1, max=1000000)
    public static int tileEntityCachedBoundingBoxUpdateInterval = 100;
    @Config.Comment(value={"Tile entities whose bounding boxes won't be cached (Accepts 'modid' or 'modid:tileentity')."})
    public static String[] tileEntityCachedBoundingBoxBlacklist = new String[0];
    @Config.Ignore
    public static ResourceLocationMap<TileEntity, Boolean> tileEntityCachedBoundingBoxBlacklistImpl = new ResourceLocationMap(arg_0 -> ((RegistryNamespaced)TileEntity.field_190562_f).func_177774_c(arg_0), false, s -> true);
    @Config.Comment(value={"Allows you to increase the render bounding boxes of entities (or all entities of a mod). Width increases the size on the X and Z axis. Top increases the size in the positive Y direction. Bottom increases the size in the negative Y direction. (Accepts 'modid=width,top,bottom' or 'modid:entity=width,top,bottom')."})
    public static String[] entityBoundingBoxGrowthList = new String[0];
    @Config.Ignore
    public static ResourceLocationMap<Entity, Vec3d> entityBoundingBoxGrowthListImpl = new ResourceLocationMap(EntityList::func_191306_a, null, s -> {
        double x = ((String[])s).length >= 1 ? Double.parseDouble(s[0]) : 0.0;
        double y = ((String[])s).length >= 2 ? Double.parseDouble(s[1]) : 0.0;
        double z = ((String[])s).length >= 3 ? Double.parseDouble(s[2]) : 0.0;
        return x != 0.0 || y != 0.0 || z != 0.0 ? new Vec3d(x, y, z) : null;
    });
    @Config.Comment(value={"Allows you to increase the render bounding boxes of tile entities (or all entities of a mod). Width increases the size on the X and Z axis. Top increases the size in the positive Y direction. Bottom increases the size in the negative Y direction. (Accepts 'modid=width,top,bottom' or 'modid:tileentity=width,top,bottom')."})
    public static String[] tileEntityBoundingBoxGrowthList = new String[0];
    @Config.Ignore
    public static ResourceLocationMap<TileEntity, Vec3d> tileEntityBoundingBoxGrowthListImpl = new ResourceLocationMap(arg_0 -> ((RegistryNamespaced)TileEntity.field_190562_f).func_177774_c(arg_0), null, s -> {
        double x = ((String[])s).length >= 1 ? Double.parseDouble(s[0]) : 0.0;
        double y = ((String[])s).length >= 2 ? Double.parseDouble(s[1]) : 0.0;
        double z = ((String[])s).length >= 3 ? Double.parseDouble(s[2]) : 0.0;
        return x != 0.0 || y != 0.0 || z != 0.0 ? new Vec3d(x, y, z) : null;
    });

    public static void onConfigChanged() {
        tileEntityCachedBoundingBoxBlacklistImpl.load(tileEntityCachedBoundingBoxBlacklist);
        entityBoundingBoxGrowthListImpl.load(entityBoundingBoxGrowthList);
        tileEntityBoundingBoxGrowthListImpl.load(tileEntityBoundingBoxGrowthList);
    }

    public static class OpenGLDebugOutput {
        @Config.Comment(value={"Better debugging of OpenGL errors. (Requires OpenGL 4.3!)"})
        public boolean enabled = false;
        @Config.Comment(value={"Enable/Disable logging of high severity non-error messages. (You probably never want to enable this as a normal user)"})
        public boolean logHighSeverity = false;
        @Config.Comment(value={"Enable/Disable logging of medium severity non-error messages. (You probably never want to enable this as a normal user)"})
        public boolean logMediumSeverity = false;
        @Config.Comment(value={"Enable/Disable logging of low severity non-error messages. (You probably never want to enable this as a normal user)"})
        public boolean logLowSeverity = false;
        @Config.Comment(value={"Enable/Disable logging of notification severity non-error messages. (You probably never want to enable this as a normal user)"})
        public boolean logNotificationSeverity = false;
    }
}

